//app
var myApp = angular.module('indexApp',['ngRoute']);
myApp.config(['$routeProvider', function($routeProvider){
    //views
    $routeProvider
    .when('/Home',{
        templateUrl:'views/Home.html',
        controller:'homeController'
    })
    .when('/About',{
        templateUrl:'views/About.html',
    })
    .when('/Contact',{
        templateUrl:'views/Contact.html',
    })
    .when('/Menu',{
        templateUrl:'views/Menu.html',
        controller:'menuController'
    })
    .when('/Order',{
        templateUrl:'views/Order.html',
        controller:'orderController'
    })
    .otherwise({
        redirectTo:'/Home'
    });
    
    }]);

    //home controller
    myApp.controller('homeController', ['$scope','$location',function($scope,$location) {
        $scope.specials=specials;  
        $scope.buttonMenu=function(){
            $location.url("/Menu");
        };
    }]);

    //order controller
    myApp.controller('orderController',['$scope', function($scope){
        $scope.order={};
        $scope.submitForm = function() {
             // Perform form submission logic here
             if ($scope.orderForm.$valid) {
                 // Form is valid, proceed with submission
                 alert('We receive your order!', $scope.order);
             } else {
                 // Form is invalid, display an error message
                 alert('Order submission failed. Please correct the errors.');
             }
         };
    
    }]);
    
    //menu controller
    myApp.controller('menuController', ['$scope', function($scope) {
        $scope.items=fullMenu;
        this.itemDesc=null;
        $scope.selectedSection = '';

        //click items for desc
        $scope.toggleEvents=function(item){
            if (this.itemDesc == item) {
                this.itemDesc = null; 
            } else {
                this.itemDesc = item;
            }
    };
    //click buttons to show only that section
    $scope.sectionButton=function(button){
        if($scope.selectedSection==button){
            $scope.selectedSection = '';
     }else{
        $scope.selectedSection=button;
        }
};
}]);
  